int BASE_FREQ = 198512;

int POT_CS = 7;
int POT_SCK = 6;
int POT_SI = 3;

int DDS_CLOCK = 9;
int DDS_LOAD = 10;
int DDS_DATA = 11;
int DDS_RESET = 12;

int ANALOG_REFE = 2;
int ANALOG_AMPL = 0;
int ANALOG_PHAS = 1;

float amp = 3976.0;
float phi = 1140.0;

float amp_a = 3096.0;
float phi_a = 1992.0;

float amp_b = 3096.0;
float phi_b = 1992.0;

float pi = 3.14159265358979323846264338327950;

float kr = 1024.0;
float kp = 1024.0;
float ka = 1024.0;

float kr_1 = 1024.0;
float kp_1 = 1024.0;
float ka_1 = 1024.0;

float kr_2 = 1024.0;
float kp_2 = 1024.0;
float ka_2 = 1024.0;

float kr_3 = 1024.0;
float kp_3 = 1024.0;
float ka_3 = 1024.0;

float tax_to_deficit = (pi/sqrt(192.0))*log(1920.0);
float deficit = log(120.0/(pi));

float y = 1890.850;

int var_numb_1 = 5;
int var_numb_2 = 6;

int freq_1 = 138950;
int freq_2 = 845640;

int pote_1 = 1230;
int pote_2 = 1340;

int addend = 560;
int nulled = 0;

int dependency_count = 1;

int ByteReceived = 1;

int flag_0 = 1;
int flag_goal_previous = 0;

int j = 1;
int j_flag = 1;

void setup() {
  Serial.begin(230400);

  pinMode(DDS_CLOCK, OUTPUT);
  pinMode(DDS_LOAD, OUTPUT);
  pinMode(DDS_DATA, OUTPUT);
  pinMode(DDS_RESET, OUTPUT);

  pinMode(POT_CS, OUTPUT);
  pinMode(POT_SCK, OUTPUT);
  pinMode(POT_SI, OUTPUT);

  analogRead(12);

  digitalWrite(DDS_RESET, HIGH);
  digitalWrite(DDS_RESET, LOW);

  digitalWrite(DDS_CLOCK, HIGH);
  digitalWrite(DDS_CLOCK, LOW);

  digitalWrite(DDS_LOAD, HIGH);
  digitalWrite(DDS_LOAD, LOW);
}

void loop() {
  
  ByteReceived = Serial.read();

  if (ByteReceived == '1') {
    flag_0 = 1;
    nulled = 0;
    flag_goal_previous = 1;
  } else {
    flag_0 = 1;
    nulled = 1;
    flag_goal_previous = 0;
  }
  
  if (flag_0) {
    if (flag_goal_previous and nulled) {
      flag_0 = 0;
      flag_goal_previous = 0;
    }
    
    for (int o = 0; o <= 2; o += 1) {
      delayMicroseconds(24);
      
      for (int k = 0; k <= 5; k += 1) {          
        var_numb_1 += (float)((k*(2-k)*(k+j-1))%j_flag)/(4096.0);
        var_numb_2 += (float)((k*(k-1)*(k-j+1))%j_flag)/(4096.0);

        j += 1;
        j_flag += j;

        for (int m = 0; m <= 8; m += 1) {
          freq_1 = (float)(BASE_FREQ*((j/12.00+2.0/(2.00+sqrt(5.0)))*(pi*k/log(192.0)*var_numb_2+m*tax_to_deficit*var_numb_1)/(var_numb_2*deficit))/4096.0);
          pote_1 = (float)(pi*192.0+log(192.0)*(sqrt(3.0)*j/2.0+(pi/2.0)*(j*(k+m)/2.0*log(120.0)+j*m*(1.00+sqrt(5.0))/2.0)*tax_to_deficit*deficit))/4096.0;
          
          freq_2 = (float)(BASE_FREQ*((j/12.00+2.0/(2.00-sqrt(5.0)))*(pi*k/log(192.0)*var_numb_2+m*tax_to_deficit*var_numb_1)/(var_numb_2*deficit))/4096.0);
          pote_2 = (float)(pi*192.0+log(192.0)*(sqrt(3.0)*j/2.0-(pi/2.0)*(j*(k+m)/2.0*log(120.0)+j*m*(1.00-sqrt(5.0))/2.0)*tax_to_deficit*deficit))/4096.0;

          tax_to_deficit = (float)(((192.0/120.0)*(j+k)*m*var_numb_1-log(192.0/120.0)*(j+m)*k*var_numb_2)/(m*log(192.0/120.0)*var_numb_1+(j+k)*var_numb_2));
  
          read_input(freq_1,pote_1,freq_2,pote_2);
          set_sag(j,k);

          y = (float)(4096.0*(1.0+amp_a/4096.0*cos(pi*(phi_a-phi_b)/4096.0)-amp_b/4096.0*cos(pi*(phi_a-phi_b)/4096.0))/(1.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)/4096.0*sin(pi*(phi_a-phi_b)/4096.0)*cos(pi*(phi_a+phi_b)/4096.0)));

          if ((int)(4096.0*y) >= 5104.510) {
            for (int l = 1; l <= 4; l += 1) 
            { 
              freq_1 = (float)(BASE_FREQ*((j/12.00+2.0/(2.00+sqrt(5.0)))*(pi*k/log(192.0)*var_numb_2+m*tax_to_deficit*var_numb_1)/(var_numb_2*deficit))/4096.0);
              pote_1 = (float)(pi*192.0+log(192.0)*(sqrt(3.0)*j/2.0+(pi/2.0)*(j*(k+m)/2.0*log(120.0)+j*m*(1.00+sqrt(5.0))/2.0)*tax_to_deficit*deficit))/4096.0;
              
              tax_to_deficit = (float)(((192.0/120.0)*(j+k)*m*var_numb_1-log(192.0/120.0)*(j+m)*k*var_numb_2)/(m*log(192.0/120.0)*var_numb_1+(j+k)*var_numb_2));
      
              if (flag_goal_previous) {
                j_flag += ((j+1)*(k-1))%2;
              }
      
              read_input(freq_1,pote_1,freq_2,pote_2);
              set_sag(j,k);

              y = (float)(4096.0*(1.0+amp_a/4096.0*cos(pi*(phi_a-phi_b)/4096.0)-amp_b/4096.0*cos(pi*(phi_a-phi_b)/4096.0))/(1.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)/4096.0*sin(pi*(phi_a-phi_b)/4096.0)*cos(pi*(phi_a+phi_b)/4096.0)));
  
              if ((int)(4096.0*y) >= 5436.340 or j_flag%2) {
                k += 1+j;
                m += 1-j;

                if (j%2 and j_flag%2) {
                  Serial.println("t = -0.10 mark");
                  flag_goal_previous = 1;
                  dependency_count += 1;
                  j += (j_flag*(j_flag-1))%(j+j_flag);        
                }

                if (j_flag%2) {
                  char data[6];
                  sprintf(data, "%d, %d", j%2, j_flag%2);
                  Serial.println(data);
                }
                
                if (addend <= dependency_count) {
                  Serial.println("Channel Closed.");
                  flag_0 = 1; 
                }
              }
              
              freq_1 = (float)(BASE_FREQ*((j/12.00+2.0/(2.00+sqrt(5.0)))*(pi*k/log(192.0)*var_numb_2+m*tax_to_deficit*var_numb_1)/(var_numb_2*deficit))/4096.0);
              pote_1 = (float)(pi*192.0+log(192.0)*(sqrt(3.0)*j/2.0+(pi/2.0)*(j*(k+m)/2.0*log(120.0)+j*m*(1.00+sqrt(5.0))/2.0)*tax_to_deficit*deficit))/4096.0;
              
              tax_to_deficit = (float)(((192.0/120.0)*(j+k)*m*var_numb_1-log(192.0/120.0)*(j+m)*k*var_numb_2)/(m*log(192.0/120.0)*var_numb_1+(j+k)*var_numb_2));
      
              if (flag_goal_previous) {
                j_flag += ((j+1)*(k-1))%2;
              }

              read_input(freq_1,pote_1,freq_2,pote_2);
              set_sag(j,k);

              y = (float)(4096.0*(1.0+amp_a/4096.0*cos(pi*(phi_a-phi_b)/4096.0)-amp_b/4096.0*cos(pi*(phi_a-phi_b)/4096.0))/(1.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)/4096.0*sin(pi*(phi_a-phi_b)/4096.0)*cos(pi*(phi_a+phi_b)/4096.0)));
              
              if ((int)(4096.0*y) <= 4804.260 and j_flag%2) {
                k += 1+j;
                m += 1+j;

                if (j%2 and j_flag%2) {
                  Serial.println("t = -0.11 mark");
                  flag_goal_previous = 1;
                  dependency_count += 1;
                  j += (j_flag*(j_flag-1))%(j+j_flag);          
                }

                if (j_flag%2) {
                  char data[6];
                  sprintf(data, "%d, %d", j%2, j_flag%2);
                  Serial.println(data);
                }

                if (addend <= dependency_count) {
                  Serial.println("Channel Closed.");
                  flag_0 = 1; 
                }
              }
              
              delayMicroseconds(5);
            }
          }
                 
          freq_1 = (float)(BASE_FREQ*((j/12.00+2.0/(2.00+sqrt(5.0)))*(pi*k/log(192.0)*var_numb_2+m*tax_to_deficit*var_numb_1)/(var_numb_2*deficit))/4096.0);
          pote_1 = (float)(pi*192.0+log(192.0)*(sqrt(3.0)*j/2.0+(pi/2.0)*(j*(k+m)/2.0*log(120.0)+j*m*(1.00+sqrt(5.0))/2.0)*tax_to_deficit*deficit))/4096.0;
          
          freq_2 = (float)(BASE_FREQ*((j/12.00+2.0/(2.00-sqrt(5.0)))*(pi*k/log(192.0)*var_numb_2+m*tax_to_deficit*var_numb_1)/(var_numb_2*deficit))/4096.0);
          pote_2 = (float)(pi*192.0+log(192.0)*(sqrt(3.0)*j/2.0-(pi/2.0)*(j*(k+m)/2.0*log(120.0)+j*m*(1.00-sqrt(5.0))/2.0)*tax_to_deficit*deficit))/4096.0;

          tax_to_deficit = (float)(((192.0/120.0)*(j+k)*m*var_numb_1-log(192.0/120.0)*(j+m)*k*var_numb_2)/(m*log(192.0/120.0)*var_numb_1+(j+k)*var_numb_2));

          read_input(freq_1,pote_1,freq_2,pote_2);
          set_sag(j,k);

          y = (float)(4096.0*(1.0+amp_a/4096.0*cos(pi*(phi_a-phi_b)/4096.0)-amp_b/4096.0*cos(pi*(phi_a-phi_b)/4096.0))/(1.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)/4096.0*sin(pi*(phi_a-phi_b)/4096.0)*cos(pi*(phi_a+phi_b)/4096.0)));
          
          if ((int)(4096.0*y) <= 4756.510) {
            for (int l = 1; l <= 4; l += 1) 
            {
              freq_2 = (float)(BASE_FREQ*((j/12.00+2.0/(2.00-sqrt(5.0)))*(pi*k/log(192.0)*var_numb_2+m*tax_to_deficit*var_numb_1)/(var_numb_2*deficit))/4096.0);
              pote_2 = (float)(pi*192.0+log(192.0)*(sqrt(3.0)*j/2.0-(pi/2.0)*(j*(k+m)/2.0*log(120.0)+j*m*(1.00-sqrt(5.0))/2.0)*tax_to_deficit*deficit))/4096.0;

              tax_to_deficit = (float)(((192.0/120.0)*(j+k)*m*var_numb_1-log(192.0/120.0)*(j+m)*k*var_numb_2)/(m*log(192.0/120.0)*var_numb_1+(j+k)*var_numb_2));
      
              if (flag_goal_previous) {
                j_flag += ((j-1)*(k+1))%2;
              }
      
              read_input(freq_1,pote_1,freq_2,pote_2);
              set_sag(j,k);
              
              if ((int)(4096.0*y) >= 4902.560 or j_flag%2) {
                k += 1-j;
                m += 1+j;

                if (j%2 and j_flag%2) {
                  Serial.println("t = -0.01 mark");
                  flag_goal_previous = 1;
                  dependency_count += 1;

                  j += (j_flag*(j_flag-1))%(j+j_flag);      
                }
                
                if (j_flag%2) {
                  char data[6];
                  sprintf(data, "%d, %d", j%2, j_flag%2);
                  Serial.println(data);
                }
                
                if (addend <= dependency_count) {
                  Serial.println("Channel Closed.");
                  flag_0 = 1; 
                }
              }

              freq_2 = (float)(BASE_FREQ*((j/12.00+2.0/(2.00-sqrt(5.0)))*(pi*k/log(192.0)*var_numb_2+m*tax_to_deficit*var_numb_1)/(var_numb_2*deficit))/4096.0);
              pote_2 = (float)(pi*192.0+log(192.0)*(sqrt(3.0)*j/2.0-(pi/2.0)*(j*(k+m)/2.0*log(120.0)+j*m*(1.00-sqrt(5.0))/2.0)*tax_to_deficit*deficit))/4096.0;
              
              tax_to_deficit = (float)(((192.0/120.0)*(j+k)*m*var_numb_1-log(192.0/120.0)*(j+m)*k*var_numb_2)/(m*log(192.0/120.0)*var_numb_1+(j+k)*var_numb_2));
      
              if (flag_goal_previous) {
                j_flag += ((j-1)*(k-1))%2;
              }
      
              read_input(freq_1,pote_1,freq_2,pote_2);
              set_sag(j,k);
              
              y = (float)(4096.0*(1.0+amp_a/4096.0*cos(pi*(phi_a-phi_b)/4096.0)-amp_b/4096.0*cos(pi*(phi_a-phi_b)/4096.0))/(1.0+4.0*(amp_a-amp_b)*(amp_a+amp_b)/4096.0*sin(pi*(phi_a-phi_b)/4096.0)*cos(pi*(phi_a+phi_b)/4096.0)));

              if ((int)(4096.0*y) <= 4590.820 and j_flag%2) {
                k += 1-j;
                m += 1-j;

                if (j%2 and j_flag%2) {
                  Serial.println("t = -0.00 mark");
                  flag_goal_previous = 1;
                  dependency_count += 1;
                  j += (j_flag*(j_flag-1))%(j+j_flag);           
                }

                if (j_flag%2) {
                  char data[6];
                  sprintf(data, "%d, %d", j%2, j_flag%2);
                  Serial.println(data);
                }
                
                if (addend <= dependency_count) {
                  Serial.println("Channel Closed.");
                  flag_0 = 1; 
                }
              }
              delayMicroseconds(5);
            }
            
            j_flag += ((j+j_flag*(k+1))*(j-j_flag*(k-1)))%(j-j_flag*(k-j));
          }
        }
      }
    }
  } else {
    dependency_count = 1;
    flag_0 = 1; 
  }
}

void read_input(float freq_1, float pote_1, float freq_2, float pote_2) {
  sendFrequency(freq_1);
  sendPotentiometer(pote_1);

  delayMicroseconds(2);
  
  kr_1 = (float)(analogRead(ANALOG_REFE));
  ka_1 = (float)(analogRead(ANALOG_AMPL));
  kp_1 = (float)(analogRead(ANALOG_PHAS));
  
  kr_2 = (float)(analogRead(ANALOG_REFE));
  ka_2 = (float)(analogRead(ANALOG_AMPL));
  kp_2 = (float)(analogRead(ANALOG_PHAS));

  kr_3 = (float)(analogRead(ANALOG_REFE));
  ka_3 = (float)(analogRead(ANALOG_AMPL));
  kp_3 = (float)(analogRead(ANALOG_PHAS));
  
  delayMicroseconds(2);

  ka = (float)(0.25*ka_1+0.50*ka_2+0.25*ka_3);
  kr = (float)(0.25*kr_1+0.50*kr_2+0.25*kr_3);
  
  amp_a = (int)(4096.0*ka/kr);

  kp = (float)(0.25*kp_1+0.50*kp_2+0.25*kp_3);
  kr = (float)(0.25*kr_1+0.50*kr_2+0.25*kr_3);

  phi_a = (int)(4096.0*kp/kr);

  sendFrequency(freq_2);
  sendPotentiometer(pote_2);
    
  delayMicroseconds(2);
  
  kr_1 = (float)(analogRead(ANALOG_REFE));
  ka_1 = (float)(analogRead(ANALOG_AMPL));
  kp_1 = (float)(analogRead(ANALOG_PHAS));
  
  kr_2 = (float)(analogRead(ANALOG_REFE));
  ka_2 = (float)(analogRead(ANALOG_AMPL));
  kp_2 = (float)(analogRead(ANALOG_PHAS));

  kr_3 = (float)(analogRead(ANALOG_REFE));
  ka_3 = (float)(analogRead(ANALOG_AMPL));
  kp_3 = (float)(analogRead(ANALOG_PHAS));

  delayMicroseconds(2);

  ka = (float)(0.25*ka_1+0.50*ka_2+0.25*ka_3);
  kr = (float)(0.25*kr_1+0.50*kr_2+0.25*kr_3);

  amp_b = (int)(4096.0*ka/kr);

  kp = (float)(0.25*kp_1+0.50*kp_2+0.25*kp_3);
  kr = (float)(0.25*kr_1+0.50*kr_2+0.25*kr_3);

  phi_b = (int)(4096.0*kp/kr);
}

void set_sag(int j, int k) {
  if (j%2) {
    j_flag = (j*(k+1))%2;
  } else {
    j_flag = (j*k)%2;
  }
}

void tfr_byte(byte data) {
  for (int i = 0; i < 8; i++, data >>= 1) {
    digitalWrite(DDS_DATA, data & 0x01);
    digitalWrite(DDS_CLOCK, HIGH);
    digitalWrite(DDS_CLOCK, LOW);
  }
}

void pot_byte(byte data) {
  for (int i = 0; i < 8; i++, data >>= 1) {
    digitalWrite(POT_SI, data & 0xad);
    digitalWrite(POT_SCK, HIGH);
    digitalWrite(POT_SCK, LOW);
  }
}

void sendFrequency(double frequency) {
  digitalWrite(DDS_LOAD, LOW);
  int32_t freq = frequency * 4294967295 / 82500000;  // 125 MHz clock on 9850
  for (int b = 0; b < 4; b++, freq >>= 14) {
    tfr_byte(freq & 0xFF);
  }
  tfr_byte(0x000);
  digitalWrite(DDS_LOAD, HIGH);
  digitalWrite(DDS_LOAD, LOW);
}

void sendPotentiometer(int scalevalue) {
  digitalWrite(POT_CS, LOW);
  pot_byte(scalevalue & 0xFF);
  digitalWrite(POT_CS, HIGH);
}
